
#define shellmenuinclude /*so other includes can tell if we've been loaded*/


#ifndef shelltypesinclude
	
	#include "shelltypes.h"

#endif


#ifdef MACVERSION
	#define firstmainmenu 1
	#define firsthiermenu 128
	#define mainmenuincrement 1
	#define hiermenuincrement 1

	#define applemenu firstmainmenu

	#define filemenu (applemenu + mainmenuincrement)
	#define editmenu (filemenu + mainmenuincrement)
	#define windowsmenu (editmenu + mainmenuincrement)
	#define fontmenu firsthiermenu
	#define stylemenu (fontmenu + hiermenuincrement)
	#define sizemenu (stylemenu + hiermenuincrement)
	#define leadingmenu (sizemenu + hiermenuincrement)
	#define justifymenu (leadingmenu + hiermenuincrement)
	#define findandreplacemenu (justifymenu + hiermenuincrement)
	#define commonstylesmenu (findandreplacemenu + hiermenuincrement)
	#define newobjectmenu (commonstylesmenu + hiermenuincrement)
	#define virtualmenu (newobjectmenu + hiermenuincrement) /*never appears in user interface -- used for externed keyboard*/
#endif

#ifdef WIN95VERSION
	#define firstmainmenu 2000
	#define firsthiermenu 3100
	#define mainmenuincrement 1000
	#define hiermenuincrement 100

	#define applemenu 1000

	// under windows, we can't use expressions for the menu #defines; the .rc compiler chokes
	#define filemenu 2000
	#define editmenu 3000
	#define windowsmenu 4000
	#define helpmenu 5000
	#define fontmenu firsthiermenu
	#define stylemenu 3200
	#define sizemenu 3300
	#define leadingmenu 3400
	#define justifymenu 3500
	#define findandreplacemenu 3600
	#define virtualmenu 3900
	#define commonstylesmenu 3700 /*7.0b26 PBS*/
	#define newobjectmenu 3800

#endif

#define aboutitem 1

#ifdef PIKE

	// #define filemenu (applemenu + mainmenuincrement)

	/*PBS 07/22/00: Pike's File menu has been revised --
	the number, order, and names of items have changed.

	7.0d10 PBS: Radio UserLand has an Update Radio.root...
	command in the File menu.*/

	#define newitem 1
	#define openitem 2
	#define openurlitem 3 /*7.0b17 PBS: Open URL... command*/
	#define openmanilasiteitem 4
	#define closeitem 5
	#define saveitem 7
	#define	saveasitem 8
	#define saveashtmlitem 9 /*7.0b32 PBS: Save As HTML... command*/
	#define saveasplaintextitem 10 /*7.0b32 PBS: Save As Plain Text... command*/
	#define revertitem 11
	#define changetitleitem 8
	#define viewinbrowseritem 13
	#define updateradiorootitem 15
	#define workofflineitem 16 /*7.0b25 PBS: Work Offline*/
	#define quititem 18

#else

	// #define filemenu (applemenu + mainmenuincrement)
	#define newitem 1
	#define openitem 2
	#define closeitem 3
	#define saveitem 5
	#define saverunnableitem 6
	#define saveasitem 7
	#define revertitem 8
	//#define expertitem 10
	#define pagesetupitem 10
	#define printitem 11
	#define quititem 13

#endif

// #define editmenu (filemenu + mainmenuincrement)
#ifdef PIKE

	#define undoitem 1
	#define cutitem 3
	#define copyitem 4
	#define pasteitem 5
	#define clearitem 6
	#define selectallitem 8
	#define windowsitem -1
	#define findandreplaceitem 10
	#define commonstylesitem 11
	#define fontitem 13
	#define sizeitem 14
	#define styleitem -1
	#define leadingitem -1
	#define justifyitem -1
	#define opennotepaditem 16
	#define insertdatetimeitem 17

#else

	#define undoitem 1
	#define cutitem 3
	#define copyitem 4
	#define pasteitem 5
	#define clearitem 6
	#define selectallitem 8
	#define windowsitem -1
	#define fontitem 10
	#define sizeitem 11
	#define styleitem 12
	#define leadingitem 13
	#define justifyitem 14

#endif

// #define windowsmenu (editmenu + mainmenuincrement)
#define hidewindowitem 1
#if TARGET_API_MAC_CARBON == 1
	#define minimizewindowitem 2
	#define bringalltofrontwindowitem 4
#endif

// #define helpmenu (windowsmenu + mainmenuincrement)
#define aboutitem 1

#define fontmenu firsthiermenu

// #define stylemenu (fontmenu + hiermenuincrement)
#define plainitem 1
#define bolditem 3
#define italicitem 4
#define underlineitem 5
#define outlineitem 6
#define shadowitem 7
/*
#define condenseditem 8
*/
#define superscriptitem 8
#define subscriptitem 9

// #define sizemenu (stylemenu + hiermenuincrement)
#define point9item 1
#define point10item 2
#define point12item 3
#define point14item 4
#define point18item 5
#define point24item 6
#define pointupitem 8
#define pointdownitem 9
#define pointcustomitem 11

// #define leadingmenu (sizemenu + hiermenuincrement)
#define leading0item 1
#define leading1item 3
#define leading2item 4
#define leading3item 5
#define leading4item 6
#define leading5item 7
#define leadingcustomitem 9

// #define justifymenu (leadingmenu + hiermenuincrement)
#define leftjustifyitem 1
#define rightjustifyitem 2
#define centerjustifyitem 3
#define fulljustifyitem 4

// #define virtualmenu (justifymenu + hiermenuincrement) /*never appears in user interface -- used for externed keyboard*/
#define helpitem 1
#define homeitem 2
#define enditem 3
#define pageupitem 4
#define pagedownitem 5
#define moveupitem 6
#define movedownitem 7
#define moveleftitem 8
#define moverightitem 9


#ifdef MACVERSION
	#define lastmainmenu windowsmenu
	#define lasthiermenu virtualmenu
#endif
#ifdef WIN95VERSION
	#define lastmainmenu helpmenu
	#define lasthiermenu newobjectmenu
#endif


#define ctmenustack (lastmainmenu - firstmainmenu + lasthiermenu - firsthiermenu + 2)

typedef struct tymenuinfo {
	
	short idmenu; /*the resource id / menu id of this menu*/
	hdlmenu macmenu; /*a handle to the menu manager's data structure for the menu*/
	} tymenuinfo;

extern tymenuinfo menustack [ctmenustack];

extern short topmenustack;


typedef enum tyeditcommand {
	
	undocommand, cutcommand = 2, copycommand, pastecommand, clearcommand, selectallcommand = 7
	
	} tyeditcommand;
	

/*prototypes*/

extern hdlmenu shellmenuhandle (short); /*shellmenu.c*/

extern boolean shelltgetmainmenu (bigstring, hdlmenu *, short *);

extern boolean shellinitmenus (void);

extern void shellgetlastmenuid (short *);

extern boolean shellapplemenu (bigstring);

extern boolean shelleditcommand (tyeditcommand);

extern void shellforcemenuadjust (void);

extern void shellmodaldialogmenuadjust (void);

extern void shellupdatemenus (void);

extern boolean shellhandlemenu (long);


extern boolean shellupdatewindowmenu (void); /*shellwindowmenu.c*/

extern void shellwindowmenuselect (short);

extern void shelladjustundo (void); /*7.0fc1 PBS: no longer static*/

extern boolean pikequit (void); /*7.0 PBS: called when the X in the frame window is clicked in Windows.*/



